function find_multistats(self)
	if self.Logic == MultiStats then
		MULTI_STATS = self
	end
end

function CreateHUDElement(x, y, image)
	local _CreateHUDElement = ffi.cast("ObjectA* (*__thiscall)(ObjectA*, int, int, int, int, int, int)", 0x4D52F0)
	local object = _CreateHUDElement(MULTI_STATS, 0, x, y, 9999, 0x520624, 0)
	object:SetImage(image)
	return object
end

function UpdateBossBar(self)
	if self.BossHealth ~= nil then
		self.bossbar.DrawFlags.NoDraw = false
		self.bossbar.I = (self.BossHealth - self.BossHealth % 5)/5+1
		self.bossbar:SetFrame(self.bossbar.I)
		--self:SetImage("CUSTOM_BOSSBAR")
		if self.Areti ~= nil then
			if self.Areti.shielded ~= nil then
				if self.Areti.shielded == 1 then
					self.bossbar.I = self.bossbar.I + 21
					self.bossbar:SetFrame(self.bossbar.I)
				end
			end
		end
	else
		self.bossbar.DrawFlags.NoDraw = true
	end
	
	
end


function det(a,b,c, d,e,f, g,h,i)
  return a*e*i+b*f*g+c*d*h-c*e*g-b*d*i-a*f*h
end

function GetJumpTrajectory(x1,y1, x2,y2, x3,y3)
  local DET = det(x1*x1, x1, 1, x2*x2, x2, 1, x3*x3, x3, 1)
  local res = {}
  res[0] = det(y1, x1, 1, y2, x2, 1, y3, x3, 1)/DET
  res[1] = det(x1*x1, y1, 1, x2*x2, y2, 1, x3*x3, y3, 1)/DET
  res[2] = det(x1*x1, x1, y1, x2*x2, x2, y2, x3*x3, x3, y3)/DET
  return res
end

local A1, A2 = 727595, 798405  -- 5^17=D20*A1+A2
local D20, D40 = 1048576, 1099511627776  -- 2^20, 2^40
local X1, X2 = 0, 1
function rand()
    local U = X2*A2
    local V = (X1*A2 + X2*A1) % D20
    V = (V*D20 + U) % D40
    X1 = math.floor(V/D20)
    X2 = V - X1*D20
    return V/D40
end

function ShakeScreen(self)
	CameraToPoint(GetClaw().X-5+rand()*10,GetClaw().Y-5+rand()*10)
end

function r()
	return math.floor(rand()*20)-10
end

function SmokeAnimation(xp, yp)
	CreateObject {x=xp, y=yp, z=4200, name="Smoke", logic="CustomLogic", image="CUSTOM_SMOKE", Counter = 0+r()}
	CreateObject {x=xp, y=yp, z=4200, name="Smoke", logic="CustomLogic", image="CUSTOM_SMOKE", Counter = 60+r()}
	CreateObject {x=xp, y=yp, z=4200, name="Smoke", logic="CustomLogic", image="CUSTOM_SMOKE", Counter = 120+r()}
	CreateObject {x=xp, y=yp, z=4200, name="Smoke", logic="CustomLogic", image="CUSTOM_SMOKE", Counter = 180+r()}
	CreateObject {x=xp, y=yp, z=4200, name="Smoke", logic="CustomLogic", image="CUSTOM_SMOKE", Counter = 240+r()}
	CreateObject {x=xp, y=yp, z=4200, name="Smoke", logic="CustomLogic", image="CUSTOM_SMOKE", Counter = 300+r()}
end

----------------------------------------------------------------------------


function main(self)	
if GetClaw().X > 11350 and GetClaw().X < 12400 and GetClaw().Y < 2500 then
	PLAY_AREA = ffi.cast("Rect*", 0x535840)[0]
	local centerX = (PLAY_AREA.Right+1)/2-1
	local centerY = (PLAY_AREA.Bottom+1)/2-1
	local centerBossName = (PLAY_AREA.Bottom+1)*0.3-1
	local endBossName = PLAY_AREA.Right + 138
	local barY = ((PLAY_AREA.Bottom+1)*0.9+15)
	local SpellCardX = (PLAY_AREA.Right+1)-448
	local SpellCardYStart = ((PLAY_AREA.Bottom+1)*0.9-32)
	local SpellCardYFinish = 32
	local bossnameStartY = PLAY_AREA.Top-66
	
	
	if self.State == 0 then
        self.State = 1
        self.AttackRect = {-128,-128,128,128}
        self.AttackTypeFlags = ObjectType.Player
		self.SCFlag = 0
		self.Attempt = Attempt()
		self.TimeStoppedTill = 0
		self.TimeStoppedDuration = 0
		self.TimeStopFlag = 0
		self.TimeStopClawState = 0
		self.TimeStopClawFrame = 0
		self.GrazeCounter = 0
		self.GrazeExtraLife = 1
		self.GrazeClawHP = 100
		self.Achievements = GetObject(4088)
		self.AsklepiosCh = 0
		self.clawmirrorflag = false
    end
	--TextOut(self.stage)
	if self.Attempt < Attempt() then
		self.Attempt = Attempt()
		if version > 1444 then
			GetFirstPalette():Set()
		end
		if self.heartbox ~= nil then
			self.heartbox:Destroy()
			self.heartbox = nil
		end
		
		if self.bossname1 ~= nil then
			self.bossname1.Y = -100
		end
		
		if self.objExc ~= nil then
			self.objExc:Destroy()
			self.objExc = nil
		end
		if self.Areti ~= nil and self.stage ~= nil then
			if self.stage <= 12 then
				self.Areti.State = 0
				self.stage = 12
				self.Areti.stage = 1
				self.Areti.Activate = 1
				self.GrazeCounter = 0
				self.GrazeExtraLife = 0
				self.GrazeClawHP = 100
				--self.Areti.spellcycleflag = 0
				if self.spellcard ~= nil then
					self.spellcard.Y = -100
				end
				self.SCFlag = 0
			
			end
		end
		self.Achievements.DamageTaken = 0
		self.AsklepiosCh = 0
	end
	
	if self.spellcard ~= nil then
		if self.spellcard.Y > SpellCardYFinish then
			self.spellcard.Y = self.spellcard.Y-4
		end
		--TextOut(self.spellcard.Y)
	end
		
	if self.stage == 0 then -- set music
		if GetClaw().State == 24 or GetClaw().State == 8 or GetClaw().State == 9 then
			SetMusic("BOSS")
			self.stage = 1
		--self.stage = 30
		--self.TimeCounter = GetTime() + 750
		end
	end
	if self.stage == 1 then -- immobilize Claw, set respawn point
		if GetClaw().State == 24 or GetClaw().State == 8 or GetClaw().State == 9 then
			GetClaw().SetAnimation(GetClaw(), "CLAW_STAND", 100)
			GetClaw().State = 5009
			if GetClaw().DrawFlags.Mirror == true then
				GetClaw().DrawFlags.Mirror = false
				self.clawmirrorflag = true
			end
			ffi.cast("int*", _nResult[0][11])[17] = GetClaw().X
			ffi.cast("int*", _nResult[0][11])[18] = GetClaw().Y
			self.stage = 2
		end
	end
	if self.stage == 2 then -- set Areti as boss, create boss health bar
		--self.Raux = GetObject(6344)
		local flags2 = ffi.new("Flags_t")
		flags2.AlwaysActive = true
		self.Areti = CreateObject {x=11976, y=2154, z=4001, I=4, name="Areti2", logic="CustomLogic", image="CUSTOM_ARETI"}
		SmokeAnimation(11976, 2154)
		self.Areti.DrawFlags.Mirror = true
		self.Areti.Flags.AlwaysActive = true
		--self.BossHealth = 100
		self.BossActive = 1
		--SetBoss(self.Areti)
		
		LoopThroughObjects(find_multistats)
		self.bossbar = CreateHUDElement(centerX, barY, "CUSTOM_BOSSBAR")
		--self.spellcard = CreateHUDElement(SpellCardX, SpellCardYStart, "CUSTOM_SPELLCARDNAME")
		
		--CameraToObject(self.Areti)
		CameraToPoint(self.Areti.X-128,self.Areti.Y)
		self.TimeCounter = GetTime()
		self.startAttempt = Attempt()
		self.stage = 3
		
		if self.Achievements.extra == false then
			self.aretidialogue = CreateObject {x=11777, y=2132, z=8000, name="SimpleLogic", logic="CustomLogic", image="CUSTOM_ARETIDIALOGUE"}
		else
			self.aretidialogue = CreateObject {x=11777, y=2132, z=8000, name="SimpleLogic", logic="CustomLogic", image="CUSTOM_ARETIDIALOGUEEXTRA"}
		end
		self.dialogueI = 1
		self.aretidialogue.I = self.dialogueI
		self.aretidialogue:SetFrame(self.dialogueI)
		
		self.dialogueCD = GetTime()
		if KeyPressed(0x0D) or KeyPressed(0x20) or KeyPressed(0x11) or KeyPressed(0x28) or KeyPressed(0x25) or KeyPressed(0x26) then
			local catchinput = true
		end
		--TextOut(self.Raux.Y)
	end
	if self.stage == 3 then -- Areti speaking
		if self.Achievements.extra == false then
			if GetTime() > self.dialogueCD + 250 then
				if KeyPressed(0x0D) or KeyPressed(0x20) or KeyPressed(0x11) or KeyPressed(0x28) or GetTime() > self.dialogueCD + 20000 then
					if self.dialogueI <= 7 then
						self.dialogueI = self.dialogueI + 1
						self.aretidialogue.I = self.dialogueI
						self.aretidialogue:SetFrame(self.dialogueI)
						self.dialogueCD = GetTime()
					else
						--self.aretidialogue:Destroy()
						self.stage = 4
					end
				elseif KeyPressed(0x25) or KeyPressed(0x26) then
					if self.dialogueI >= 2 then
						self.dialogueI = self.dialogueI - 1
						self.aretidialogue.I = self.dialogueI
						self.aretidialogue:SetFrame(self.dialogueI)
						self.dialogueCD = GetTime()
					end
				end
			end
		else
			if GetTime() > self.dialogueCD + 250 then
				if KeyPressed(0x0D) or KeyPressed(0x20) or KeyPressed(0x11) or KeyPressed(0x28) or GetTime() > self.dialogueCD + 20000 then
					self.stage = 4
				end
			end
		end
		
		--if self.TimeCounter + 500 < GetTime() then
		
			--self.objExc = CreateObject {x=self.Areti.X, y=self.Areti.Y-90, z=9000, logic="BlinkingEyes", image="GAME_EXCLAMATION"}
			--PlaySound("CUSTOM_TRIGGER_INTRUDER")
			--PlaySound("CUSTOM_TRIGGER_ENEMY1")
			--self.TimeCounter = GetTime()
			--self.stage = 4
		--end
	end
	if self.stage == 4 then -- Claw speaking
		if self.TimeCounter + 1500 < GetTime() then
			--TextOut(GetClaw().Y)
			local obj = self.aretidialogue
			obj:Destroy()
			self.aretidialogue = nil
			CameraToObject(GetClaw())
			--ClawSound("CUSTOM_TRIGGER_CLAW1")
			self.TimeCounter = GetTime()
			self.stage = 5
		end
	end
	if self.stage == 5 then -- "Defeat Areti"
		if self.TimeCounter + 2000 < GetTime() then
			self.bossname1 = CreateHUDElement(centerX, bossnameStartY, "CUSTOM_BOSSNAME")
			PlaySound("GAME_SDPT1")
			self.TimeCounter = GetTime()
			self.stage = 6
		end
	end
	if self.stage == 6 then -- bossname going in animation
		local animationLen = 2029
		self.bossname1.Y = bossnameStartY+(centerBossName-bossnameStartY)*( GetTime()-self.TimeCounter )/ animationLen
		--TextOut(self.bossname1.Y)
		if self.TimeCounter + animationLen < GetTime() then
			self.TimeCounter = GetTime()
			self.stage = 7
		end
	end
	if self.stage == 7 then -- sound
		PlaySound("GAME_SDPT2")
		self.TimeCounter = GetTime()
		self.stage = 8
	end
	if self.stage == 8 then -- shake screen, play "defeat ..." sound
		ShakeScreen()
		if self.TimeCounter + 500 < GetTime() then
			CameraToClaw()
			--PlaySound("CUSTOM_TRIGGER_DEFEAT1")
			self.TimeCounter = GetTime()
			self.stage = 9
		end
	end
	if self.stage == 9 then -- wait for sound to finish
		if self.TimeCounter + 1250 < GetTime() then
			self.TimeCounter = GetTime()
			self.stage = 10
		end
	end
	if self.stage == 10 then -- bossname going out animation
		local animationLen = 750
		self.bossname1.X = centerX+(endBossName-centerX)*( GetTime()-self.TimeCounter )/ animationLen
		--TextOut(self.bossname1.X)
		if self.TimeCounter + animationLen < GetTime() then
			self.bossname1:Destroy()
			self.bossname1 = nil
			--self.TimeCounter = GetTime()
			self.stage = 11
		end
	end
	if self.stage == 11 then 
		if self.clawmirrorflag == true then
			GetClaw().DrawFlags.Mirror = true
		end
		GetClaw().State = 24 -- unfreeze Claw
		self.Areti.Activate = 1
		--CreateObject {x=claw.X, y=claw.Y, z=6000, logic="CustomLogic", name="Heartbox", image="CUSTOM_HEARTBOX"}
		self.stage = 12
	end
	
	if self.stage == 12 then -- when Areti's health falls to 20%, start the cutscene
		local claw = GetClaw()
		
		if self.aretidialogue ~= nil then
			local obj = self.aretidialogue
			obj:Destroy()
			self.aretidialogue = nil
		end
		
		if self.AsklepiosCh == 0 and claw.Health <= 5 and claw.Health >= 1 then
			self.AsklepiosCh = 1
		elseif self.AsklepiosCh == 1 and claw.Health >= 95 then
			self.AsklepiosCh = 2
			self.Achievements.Asklepios = 1
		end
		
		if self.Areti.stage >= 2 then
			if self.spellcard == nil then
				self.spellcard = CreateHUDElement(SpellCardX, SpellCardYStart, "CUSTOM_SPELLCARDNAME")
			end
		end
		
		
		if self.Areti.stage == 2 and self.SCFlag ~= 2 and claw.Health > 0 then
			self.SCFlag = 2
			self.spellcard.Y = SpellCardYStart
			if self.Achievements.HardMode == false and self.Achievements.extra == false then
				self.spellcard.I = 1
			elseif self.Achievements.extra == false then
				self.spellcard.I = 6
			else
				self.spellcard.I = 1
			end
			self.spellcard:SetFrame(self.spellcard.I)
		
		elseif self.Areti.stage == 3 and self.SCFlag ~= 3 and claw.Health > 0 then
			self.SCFlag = 3
			self.spellcard.Y = -100
			if self.Achievements.extra == true then
				self.Achievements.ExtraA = 1
				self.Achievements.ExtraStage = 1
			end
		
		elseif self.Areti.stage == 4 and self.SCFlag ~= 4 and claw.Health > 0 then
			self.SCFlag = 4
			self.spellcard.Y = SpellCardYStart
			if self.Achievements.HardMode == false and self.Achievements.extra == false then
				self.spellcard.I = 2
			elseif self.Achievements.extra == false then
				self.spellcard.I = 7
			else
				self.spellcard.I = 2
			end
			self.spellcard:SetFrame(self.spellcard.I)
		
		elseif self.Areti.stage == 5 and self.SCFlag ~= 5 and claw.Health > 0 then
			self.SCFlag = 5
			self.spellcard.Y = -100
			if self.Achievements.extra == true then
				self.Achievements.ExtraStage = 2
			end
		
		elseif self.Areti.stage == 6 and self.SCFlag ~= 6 and claw.Health > 0 then
			self.SCFlag = 6
			self.spellcard.Y = SpellCardYStart
			if self.Achievements.HardMode == false and self.Achievements.extra == false then
				self.spellcard.I = 3
			elseif self.Achievements.extra == false then
				self.spellcard.I = 8
			else
				self.spellcard.I = 3
			end
			self.spellcard:SetFrame(self.spellcard.I)
		
		elseif self.Areti.stage == 7 and self.SCFlag ~= 7 and claw.Health > 0 then
			self.SCFlag = 7
			self.spellcard.Y = -100
			if self.Achievements.extra == true then
				self.Achievements.ExtraStage = 3
			end
		
		elseif self.Areti.stage == 8 and self.SCFlag ~= 8 and claw.Health > 0 then
			self.SCFlag = 8
			self.spellcard.Y = SpellCardYStart
			if self.Achievements.HardMode == false and self.Achievements.extra == false then
				self.spellcard.I = 4
			elseif self.Achievements.extra == false then
				self.spellcard.I = 9
			else
				self.spellcard.I = 4
			end
			self.spellcard:SetFrame(self.spellcard.I)
		
		elseif self.Areti.stage == 9 and self.SCFlag ~= 9 and claw.Health > 0 then
			self.SCFlag = 9
			self.spellcard.Y = -100
			if self.Achievements.extra == true then
				self.Achievements.ExtraStage = 4
			end
		
		elseif self.Areti.stage == 10 and self.SCFlag ~= 10 and claw.Health > 0 then
			self.SCFlag = 10
			self.spellcard.Y = SpellCardYStart
			if self.Achievements.HardMode == false and self.Achievements.extra == false then
				self.spellcard.I = 5
			elseif self.Achievements.extra == false then
				self.spellcard.I = 10
			else
				self.spellcard.I = 5
			end
			self.spellcard:SetFrame(self.spellcard.I)
		
		elseif self.Areti.stage == 11 and self.SCFlag ~= 11 and claw.Health > 0 then
			self.SCFlag = 11
			self.spellcard.Y = -100
			if self.Achievements.extra == true then
				self.Achievements.ExtraStage = 5
			end
		
		elseif self.Areti.stage == 12 and self.SCFlag ~= 12 and claw.Health > 0 then
			self.SCFlag = 12
			self.spellcard.Y = SpellCardYStart
			if self.Achievements.extra == true then
				self.spellcard.I = 6
			end
			self.spellcard:SetFrame(self.spellcard.I)
		
		elseif self.Areti.stage == 13 and self.SCFlag ~= 13 and claw.Health > 0 then
			self.SCFlag = 13
			self.spellcard.Y = -100
			if self.Achievements.extra == true then
				self.Achievements.ExtraStage = 6
			end
		
		elseif self.Areti.stage == 14 and self.SCFlag ~= 14 and claw.Health > 0 then
			self.SCFlag = 14
			self.spellcard.Y = SpellCardYStart
			if self.Achievements.extra == true then
				self.spellcard.I = 7
			end
			self.spellcard:SetFrame(self.spellcard.I)
		
		elseif self.Areti.stage == 15 and self.SCFlag ~= 15 and claw.Health > 0 then
			self.SCFlag = 15
			self.spellcard.Y = -100
			if self.Achievements.extra == true then
				self.Achievements.ExtraStage = 7
			end
		
		elseif self.Areti.stage == 16 and self.SCFlag ~= 16 and claw.Health > 0 then
			self.SCFlag = 16
			self.spellcard.Y = SpellCardYStart
			if self.Achievements.extra == true then
				self.spellcard.I = 8
			end
			self.spellcard:SetFrame(self.spellcard.I)
		
		elseif self.Areti.stage == 17 and self.SCFlag ~= 17 and claw.Health > 0 then
			self.SCFlag = 17
			self.spellcard.Y = -100
			if self.Achievements.extra == true then
				self.Achievements.ExtraStage = 8
			end
		
		elseif self.Areti.stage == 18 and self.SCFlag ~= 18 and claw.Health > 0 then
			self.SCFlag = 18
			self.spellcard.Y = SpellCardYStart
			if self.Achievements.extra == true then
				self.spellcard.I = 9
			end
			self.spellcard:SetFrame(self.spellcard.I)
		
		elseif self.Areti.stage == 19 and self.SCFlag ~= 19 and claw.Health > 0 then
			self.SCFlag = 19
			self.spellcard.Y = -100
			if self.Achievements.extra == true then
				self.Achievements.ExtraStage = 9
			end
		
		elseif self.Areti.stage == 20 and self.SCFlag ~= 20 and claw.Health > 0 then
			self.SCFlag = 20
			self.spellcard.Y = SpellCardYStart
			if self.Achievements.extra == true then
				self.spellcard.I = 10
			end
			self.spellcard:SetFrame(self.spellcard.I)
		
		elseif self.Areti.stage == 21 and self.SCFlag ~= 21 and claw.Health > 0 then
			self.SCFlag = 21
			self.spellcard.Y = -100
			if self.Achievements.extra == true then
				self.Achievements.ExtraStage = 10
			end
		
		elseif (self.Areti.stage == 22 or self.Areti.stage == 23 or self.Areti.stage == 24 or self.Areti.stage == 25) and self.SCFlag ~= 22 and claw.Health > 0 then
			self.SCFlag = 22
			self.spellcard.Y = SpellCardYStart
			if self.Achievements.extra == true then
				self.spellcard.I = 11
			end
			self.spellcard:SetFrame(self.spellcard.I)
			
		elseif self.Areti.stage == 26 and self.SCFlag ~= 23 and claw.Health > 0 then
			self.SCFlag = 23
			self.spellcard.Y = -100
			if self.Achievements.extra == true then
				self.Achievements.ExtraStage = 11
			end
			
		end
		
		if self.heartbox == nil then
			local claw = GetClaw()
			self.heartbox = CreateObject {x=claw.X, y=claw.Y, z=6000, logic="CustomLogic", name="Heartbox", image="CUSTOM_HEARTBOX"}
		end
		
		self.TimeStoppedTill = self.Areti.TimeStoppedTill
		self.TimeStoppedDuration = self.Areti.TimeStoppedDuration
		
		if self.TimeStopFlag == 0 then
			if self.TimeStoppedTill >= GetTime() and GetClaw().Health > 0 then
				self.TimeStopFlag = 1
				self.TimeStopClawState = GetClaw().State
				self.TimeStopClawFrame = GetClaw().I
				GetClaw().Height = 0
				GetClaw().State = 5009
				GetClaw().SetAnimation(GetClaw(), "GAME_NULL", 0)
				if self.heartbox ~= nil then
					self.heartbox:SetAnimation("GAME_NULL")
				end
				if version > 1444 then
					GetCurrentPalette():BlackAndWhite():Set()
				end
				PlaySound("CUSTOM_TRIGGER_TIMESTOP")
			end
		elseif self.TimeStopFlag == 1 then
			if GetClaw().Health > 0 then
				local claw = GetClaw()
				claw:SetFrame(self.TimeStopClawFrame)
				GetClaw().State = 5009
				if self.TimeStoppedTill < GetTime() then
					self.TimeStopFlag = 0
					GetClaw().State = self.TimeStopClawState
					
					if self.heartbox ~= nil then
						self.heartbox:SetAnimation("GAME_CYCLE100")
					end
					if version > 1444 then
						GetFirstPalette():Set()
					end
					PlaySound("CUSTOM_TRIGGER_TIMESTART")
				end
			else
				self.TimeStopFlag = 0
				if version > 1444 then
					GetFirstPalette():Set()
				end
				GetClaw().State = self.TimeStopClawState
				KillClaw()
				
				if self.heartbox ~= nil then
					self.heartbox:SetAnimation("GAME_CYCLE100")
				end
				
			end
		end
		
		if self.GrazeCounter >= 20 and GetClaw().Health > 0 then
			if self.GrazeExtraLife == 0 then
				PlayerData().Lives = PlayerData().Lives + 1
				PlaySound("GAME_EXTRALIFE")
				self.GrazeExtraLife = 1
			elseif GetClaw().Health < 95 then
				if GetClaw().Health <= 5 then
					GetClaw().Health = GetClaw().Health + 10
				elseif GetClaw().Health < 90 and self.GrazeClawHP == GetClaw().Health then
					GetClaw().Health = GetClaw().Health + 10
				else
					GetClaw().Health = GetClaw().Health + 5
				end
				local deathcount = Attempt() - self.startAttempt
				if self.Achievements.extra == false and self.Achievements.HardMode == false and deathcount >= 5 then
					if GetClaw().Health < 90 then
						GetClaw().Health = GetClaw().Health + 10
					else
						GetClaw().Health = GetClaw().Health + 5
					end
				end
				PlaySound("GAME_FOODITEM")
			end
			self.GrazeCounter = 0
			self.GrazeClawHP = GetClaw().Health
		end
		
		if self.Areti ~= nil then
			if self.Areti.State == 10 and GetClaw().Health > 0 then -- TODO Areti's State
				local claw = GetClaw()
				
				self.dialogueI = 1
				local deathcount = Attempt() - self.startAttempt
				--TextOut(Attempt() .. " - " .. self.startAttempt .. " = " .. deathcount)
				if deathcount >= 1 and deathcount <= 4 then
					self.dialogueI = 2
				elseif deathcount >= 5 then
					self.dialogueI = 3
				end
				if self.Achievements.extra == false then
					claw.X = 11800
					claw.Y = 2250
					claw:AlignToGround()
					CameraToClaw()
					claw.SetAnimation(GetClaw(), "CLAW_STAND", 100)
					claw.State = 5009
					self.Areti.DrawFlags.Mirror = true
					self.TimeCounter = GetTime()
					--CameraToObject(self.Areti)
					CameraToPoint(self.Areti.X+128,self.Areti.Y)
					
					self.aretidialogue = CreateObject {x=11870, y=2132, z=8000, I=self.dialogueI, name="SimpleLogic", logic="CustomLogic", image="CUSTOM_ARETIDIALOGUE2"}
				else
					claw.X = 11555
					claw.Y = 2250
					claw:AlignToGround()
					CameraToClaw()
					claw.SetAnimation(GetClaw(), "CLAW_STAND", 100)
					claw.State = 5009
					self.Areti.DrawFlags.Mirror = false
					self.TimeCounter = GetTime()
					--CameraToObject(self.Areti)
					CameraToPoint(self.Areti.X-128,self.Areti.Y+128)
					
					self.aretidialogue = CreateObject {x=11650, y=2132, z=8000, I=1, name="SimpleLogic", logic="CustomLogic", image="CUSTOM_ARETIDIALOGUEEXTRA2"}
				end
				--self.aretidialogue:SetAnimation("GAME_NULL")
				--self.aretidialogue.I = self.dialogueI
				--self.aretidialogue:SetFrame(self.dialogueI)
				self.dialogueCD = GetTime()
				if KeyPressed(0x0D) or KeyPressed(0x20) or KeyPressed(0x11) or KeyPressed(0x28) or KeyPressed(0x25) or KeyPressed(0x26) then
					local catchinput = true
				end
				
				self.stage = 13
			end
		end
		
	end
	if self.stage == 13 then
		if self.TimeCounter + 500 < GetTime() then
			if GetTime() > self.dialogueCD + 250 then
				if KeyPressed(0x0D) or KeyPressed(0x20) or KeyPressed(0x11) or KeyPressed(0x28) or GetTime() > self.dialogueCD + 20000 then
					self.stage = 14
				end
			end
			
			--self.objExc = CreateObject {x=self.Areti.X, y=self.Areti.Y-90, z=9000, logic="BlinkingEyes", image="GAME_EXCLAMATION"}
			--PlaySound("CUSTOM_TRIGGER_INTRUDER")
			--PlaySound("CUSTOM_TRIGGER_ENEMY1")
			--self.TimeCounter = GetTime()
			--self.stage = 14
			
		end
	end
	if self.stage == 14 then
		if self.TimeCounter + 1500 < GetTime() then
			--TextOut(GetClaw().Y)
			self.spellcard.Y = -100
			--local obj1 = self.aretidialogue
			if self.aretidialogue ~= nil then
				self.aretidialogue:Destroy()
			end
			--self.aretidialogue = nil
			--local obj = self.objExc
			--obj:Destroy()
			--self.objExc = nil
			local claw = GetClaw()
			if self.Achievements.extra == false then
				CreateObject {x=claw.X, y=claw.Y-140, z=9000, logic="DoNothing", image="CUSTOM_ARETIKEY"}
				self.hiddenwarp = CreateObject {x=claw.X, y=claw.Y-140, z=9000, logic="SpecialPowerup", image="GAME_VERTWARP", SpeedX = 14127, SpeedY = 3306, Smarts = 1}
				self.hiddenwarp.DrawFlags.NoDraw = true
			else
				CreateObject {x=claw.X, y=claw.Y-140, z=4000, logic="EndLevelGem", image="GAME_CHECKEDFLAG"}
			end
			
			SmokeAnimation(self.Areti.X, self.Areti.Y)
			self.Areti:Destroy()
			self.BossActive = 0
			self.BossHealth = nil
			self.TimeCounter = GetTime()
			self.heartbox:Destroy()
			self.heartbox = nil
			if version > 1444 then
				StopMusic("BOSS")
			end
			SetMusic("LEVEL")
			GetClaw().State = 24
			CameraToClaw()
			self.stage = 15
		end
		
		if GetClaw().Health == 0 and GetClaw().State == 24 then
			--GetClaw().State = 24
			
			if self.aretidialogue ~= nil then
				self.aretidialogue:Destroy()
			end
			GetClaw().Health = 100
			KillClaw()
		end
	end
	--[[
	if self.stage == 13 then -- spawn a Vice Admiral
		if self.TimeCounter + 3500 < GetTime() then
			--self.TimeCounter = GetTime()
			SummonCaptain(self)
			self.stage = 14
		end
	end
	if self.stage == 14 then -- wait for Vice Admiral defeat
		if self.vadmrl.I == 950 or self.vadmrl.Health == 0 then
			self.vadmrl.Health = 0
			self.vadmrl = nil
			RauxEngagement(self)
			self.stage = 15
		end
	end
	if self.stage == 15 then -- Raux jumps back to safe spot
		if self.BossHealth <= 75 then
			RauxWithdrawal(self)
			self.stage = 16
		end
	end
	if self.stage == 16 then -- the Destroyer launches a barrage towards Claw
		DestroyerShootCommand(self)
		self.stage = 17
		self.TimeCounter = GetTime()
		
	end
	if self.stage == 17 then -- spawn a Vice Admiral
		if self.TimeCounter + 3500 < GetTime() then
			--self.TimeCounter = GetTime()
			SummonCaptain(self)
			self.stage = 18
		end
	end
	if self.stage == 18 then -- wait for Vice Admiral defeat
		if self.vadmrl.I == 950 or self.vadmrl.Health == 0 then
			self.vadmrl.Health = 0
			self.vadmrl = nil
			RauxEngagement(self)
			self.stage = 19
		end
	end
	if self.stage == 19 then -- Raux jumps back to safe spot
		if self.BossHealth <= 50 then
			RauxWithdrawal(self)
			self.stage = 20
		end
	end
	if self.stage == 20 then -- the Destroyer launches a barrage towards Claw
		DestroyerShootCommand(self)
		self.stage = 21
		self.TimeCounter = GetTime()
		
	end
	if self.stage == 21 then -- spawn a Vice Admiral
		if self.TimeCounter + 3500 < GetTime() then
			--self.TimeCounter = GetTime()
			SummonCaptain(self)
			self.stage = 22
		end
	end
	if self.stage == 22 then -- wait for Vice Admiral defeat
		if self.vadmrl.I == 950 or self.vadmrl.Health == 0 then
			self.vadmrl.Health = 0
			self.vadmrl = nil
			RauxEngagement(self)
			self.stage = 23
		end
	end
	if self.stage == 23 then -- Raux jumps back to safe spot
		if self.BossHealth <= 25 then
			RauxWithdrawal(self)
			self.stage = 24
		end
	end
	if self.stage == 24 then -- the Destroyer launches a barrage towards Claw
		DestroyerShootCommand(self)
		self.stage = 25
		self.TimeCounter = GetTime()
		
	end
	if self.stage == 25 then -- spawn a Vice Admiral
		if self.TimeCounter + 3500 < GetTime() then
			--self.TimeCounter = GetTime()
			SummonCaptain(self)
			self.stage = 26
		end
	end
	if self.stage == 26 then -- wait for Vice Admiral defeat
		if self.vadmrl.I == 950 or self.vadmrl.Health == 0 then
			self.vadmrl.Health = 0
			self.vadmrl = nil
			RauxEngagement(self)
			self.stage = 27
		end
	end
	if self.stage == 27 then -- Raux curses Claw
		if self.BossHealth <= 5 then
			self.RauxDummy2 = CreateObject {x=self.Raux.X, y=self.Raux.Y, z=4000, logic="AniCycleNormal", image="CUSTOM_RAUXSAYSNWORD"}
			self.RauxDummy2:SetAnimation("GAME_FORWARD200")
			--local claw = GetClaw()
			GetClaw().State = -1
			self.TimeCounter = GetTime()
			PlaySound("GAME_CURSE1")
			if self.RauxDummy2.X < GetClaw().X then
				self.RauxDummy2.DrawFlags.Mirror = true
			end
			--self.Raux:Destroy()
			--self.Raux = nil
			self.BossActive = 0
			
			--self.Raux = CreateObject {x=83180, y=5529, z=4000, logic="Raux", image="LEVEL_RAUX"}
			--self.Raux.DrawFlags.NoDraw = true
			self.stage = 28
		end
	end
	if self.stage == 28 then -- Raux attempts escape
		
		CameraToObject(self.RauxDummy2)
		if self.RauxDummy2.I >= 8 then
			
			self.RauxDummy3 = CreateObject {x=self.RauxDummy2.X, y=self.RauxDummy2.Y, z=4000, logic="AniCycleNormal", image="LEVEL_RAUX"}
			self.RauxDummy3:SetAnimation("LEVEL_RAUX_FASTADVANCE")
			self.RauxDummy3.DrawFlags.Mirror = true
			self.RauxDummy2:Destroy()
			self.RauxDummy2 = nil
			self.stage = 29
		end
	end
	if self.stage == 29 then -- Raux retreating
		CameraToObject(self.RauxDummy3)
		self.RauxDummy3.X = self.RauxDummy3.X + 3
		if self.RauxDummy3.X >= 83770 then
			self.RauxDummy3:SetAnimation("LEVEL_RAUX_IDLE")
			self.RauxDummy3.DrawFlags.Mirror = false
	
			self.objExc1 = CreateObject {x=self.RauxDummy3.X, y=self.RauxDummy3.Y-80, z=9000, logic="BlinkingEyes", image="GAME_EXCLAMATION"}
			
			PlaySound("LEVEL_RAUX_00840003")
			self.TimeCounter = GetTime()
			self.stage = 30
		end
	end
	if self.stage == 30 then -- Not the last laugh
		if self.TimeCounter + 750 < GetTime() then
			--if self.objExc1 ~= nil then
			local obj1 = self.objExc1
			obj1:Destroy()
			self.objExc1 = nil
			
			self.RedtaiL1 = CreateObject {x=83770, y=4990, z=4001, logic="AniCycleNormal", image="LEVEL_REDTAIL"}
			self.RedtaiL1.I = 802
			self.RedtaiL1:SetFrame(self.RedtaiL1.I)
			
			self.stage = 31
		end
	end
	if self.stage == 31 then -- Red Tail makes appearance
		--TextOut(self.RedtaiL1.Y)
		if self.RedtaiL1.Y <= 5290 then
			self.RedtaiL1.Y = self.RedtaiL1.Y + 10
			self.RedtaiL1.I = 802
			self.RedtaiL1:SetFrame(self.RedtaiL1.I)
		else
			self.RedtaiL1.I = 100
			self.RedtaiL1:SetAnimation("LEVEL_REDTAIL_IDLE")
			--DoNothingNormal(self.RauxDummy3)
			self.RauxDummy4 = CreateObject {x=self.RauxDummy3.X, y=self.RauxDummy3.Y+32, z=3500, logic="DoNothingNormal", image="LEVEL_RAUX"}
			self.RauxDummy3:Destroy()
			self.RauxDummy3 = null
			self.RauxDummy4.I = 904
			self.RauxDummy4:SetFrame(self.RauxDummy4.I)
			PlaySound("LEVEL_RAUX_00840005")
			--BossHealth = nil
			PlaySound("CUSTOM_TRIGGER_JOJO1")
			
			if self.achievementRaux == 1 then
				self.Achievements.achievements_input[2] = 1
			end
			self.BossHealth = 0
			self.TimeCounter = GetTime()
			self.stage = 32
		end
	end
	if self.stage ~= nil then
		if self.stage < 31 and self.stage > 11 then
			if GetClaw().State == 31 then
				self.achievementRaux = 0
				--TextOut("DMG Taken")
			end
		end
	end
	if self.stage == 32 then -- (not) The last laugh, Red Tail talks, setting new respawn coords
		if self.TimeCounter + 1000 < GetTime() then
			PlaySound("LEVEL_REDTAIL_01040022")
			self.objExc2 = CreateObject {x=self.RedtaiL1.X, y=self.RedtaiL1.Y-80, z=9000, logic="DoNothing", image="GAME_EXCLAMATION"}
			--local claw = GetClaw()
			GetClaw().X = 83422
			GetClaw().Y = 5295
			
			GetClaw().SetAnimation(GetClaw(), "CLAW_STAND", 100)
			GetClaw().State = 5009
			ffi.cast("int*", _nResult[0][11])[17] = 83422
			ffi.cast("int*", _nResult[0][11])[18] = 5275
			GetClaw().DrawFlags.Mirror = false
			
			self.TimeCounter = GetTime()
			self.stage = 33
		end
	end
	if self.stage == 33 then -- Claw no nonsense
		if self.TimeCounter + 1435 < GetTime() then
			--TextOut(GetClaw().Y)
			self.objExc2.DrawFlags.NoDraw = true
			CameraToObject(GetClaw())
			ClawSound("CUSTOM_TRIGGER_MEASUREDINSECONDS")
			self.TimeCounter = GetTime()
			
			self.stage = 34
		end
	end
	
	if self.stage == 34 then -- "Defeat RedTail"
		if self.TimeCounter + 3009 < GetTime() then
			self.bossname2 = CreateHUDElement(centerX, bossnameStartY, "CUSTOM_BOSSNAME2")
			PlaySound("GAME_SDPT1")
			self.TimeCounter = GetTime()
			if self.BossHealth < 100 then
				self.BossHealth = self.BossHealth + 1
			end
			self.stage = 35
		end
	end
	if self.stage == 35 then -- bossname going in animation
		local animationLen = 2029
		self.bossname2.Y = bossnameStartY+(centerBossName-bossnameStartY)*( GetTime()-self.TimeCounter )/ animationLen
			
		if self.TimeCounter + animationLen < GetTime() then
			self.TimeCounter = GetTime()
			self.stage = 36
		end
	end
	if self.stage == 36 then -- sound
		PlaySound("GAME_SDPT2")
		self.TimeCounter = GetTime()
		self.stage = 37
	end
	if self.stage == 37 then -- shake screen, play "defeat ..." sound
		ShakeScreen()
		if self.TimeCounter + 500 < GetTime() then
			CameraToClaw()
			PlaySound("CUSTOM_TRIGGER_DEFEAT2")
			self.TimeCounter = GetTime()
			self.stage = 38
		end
	end
	if self.stage == 38 then -- wait for sound to finish
		if self.TimeCounter + 1250 < GetTime() then
			self.TimeCounter = GetTime()
			self.stage = 39
		end
	end
	if self.stage == 39 then -- bossname going out animation
		local animationLen = 750
		self.bossname2.X = centerX+(endBossName-centerX)*( GetTime()-self.TimeCounter )/ animationLen
		--TextOut(self.bossname2.X)
		if self.TimeCounter + animationLen < GetTime() then
			self.bossname2 = nil
			--self.TimeCounter = GetTime()
			self.stage = 40
		end
	end
	if self.stage == 40 then 
		GetClaw().State = 24 -- unfreeze Claw, RT fight happens here
		
		self.RedTail = CreateObject {x=83770, y=5290, z=4000, name="RedTail", logic="CustomLogic", image="LEVEL_REDTAIL"}
		self.BossActive = 2
		--SetBoss(self.RedTail)
		if self.RedtaiL1 ~= nil then
			self.RedtaiL1:Destroy()
			self.RedtaiL1 = nil
		end
		self.achievementRedTail = 1
		self.stage = 41
	end
	if self.stage == 41 then -- if RT health falls to 5%, activate strong wind to push Claw tyo the wall
		--if GetClaw().Health > 0 then
		if GetClaw().State == 31 then
			self.achievementRedTail = 0
			--TextOut("DMG Taken")
		end
		if self.RedTail ~= nil then
			if self.RedTail.Health <= 5 then
				self.RedTail2 = CreateObject {x=self.RedTail.X, y=self.RedTail.Y, z=4000, logic="AniCycle", image="LEVEL_REDTAIL"}
				self.RedTail2:SetAnimation("LEVEL_REDTAIL_HEHECHYBA")
				PlaySound("LEVEL_REDTAIL_01040007")
				self.BossActive = 3
				self.RedTail:Destroy()
				self.RedTail = nil
				
				self.objExc2.X = self.RedTail2.X
				self.objExc2.Y = self.RedTail2.Y-80
				self.objExc2.DrawFlags.NoDraw = false
				
				if self.RedTail2.X <= 83622 then
					self.RTWind = CreateObject {x=83637, y=5326, z=10000, logic="ConveyorBelt", image="GAME_SOUNDICON", Speed = 400}
					self.RedTail2.DrawFlags.Mirror = true
					PlaySound("LEVEL_REDTAIL_01040020")
				else
					self.RTWind = CreateObject {x=83637, y=5326, z=10000, logic="ConveyorBelt", image="GAME_SOUNDICON", Speed = -400}
					self.RedTail2.DrawFlags.Mirror = false
					PlaySound("LEVEL_REDTAIL_01040012")
				end
				self.RTWind.DrawFlags.NoDraw = true
				self.RTWind.MoveRect = {-256,-32,256,64}
				PlaySound("LEVEL_REDTAIL_WINDWHISTLING2")
				self.OnceFlag = 0
				
				self.stage = 42
			end
		end
	end
	
	if self.stage == 42 then
		if GetClaw().State == 24 or GetClaw().State == 8 or GetClaw().State == 9 then
			GetClaw().SetAnimation(GetClaw(), "CLAW_STAND", 100)
			GetClaw().State = 24
			CameraToPoint(83622,5326)
			self.TimeCounter = GetTime()
			self.stage = 43
		end
	end
	if self.stage == 43 then
		if self.TimeCounter + 1700 < GetTime() then
			PlaySound("LEVEL_REDTAIL_01040002")
			self.TimeCounter = GetTime()
			self.stage = 44
		end
	end
	if self.stage == 44 then
		if self.TimeCounter + 1700 < GetTime() then
			PlaySound("LEVEL_REDTAIL_01040004")
			self.TimeCounter = GetTime()
			self.stage = 45
		end
	end
	if self.stage == 45 then
		if self.TimeCounter + 1268 < GetTime() then
			self.objExc2.DrawFlags.NoDraw = true
		end
		if self.TimeCounter + 1700 < GetTime() then
			ClawSound("CUSTOM_TRIGGER_SECONDMISTAKE")
			self.TimeCounter = GetTime()
			self.stage = 46
		end
	end
	if self.stage == 46 then
		if self.TimeCounter + 2000 < GetTime() then
			GetClaw().SetAnimation(GetClaw(), "CLAW_MAGIC", 100)
			--GetClaw().State = 5009
			self.stage = 47
		end
	end
	if self.stage == 47 then
		if GetClaw().I == 167 then
			if self.RedTail2.DrawFlags.Mirror then
				local dir = -1
				self.TacticalMagicClaw = CreateObject {x=GetClaw().X-20, y=GetClaw().Y-10, z=4100, logic="MagicBullet", image="GAME_MAGICCLAW", SpeedX = 800*dir}
				
			else
				local dir = 1
				self.TacticalMagicClaw = CreateObject {x=GetClaw().X+20, y=GetClaw().Y-10, z=4100, logic="MagicBullet", image="GAME_MAGICCLAW", SpeedX = 800*dir}
				
			end
			self.TimeCounter = GetTime()
			if PlayerData().MagicAmmo >= 1 then
				PlayerData().MagicAmmo = PlayerData().MagicAmmo - 1
			else
				GetClaw().Health = 1
			end
			self.stage = 48
		end
	end
	if self.stage == 48 then
		if self.TimeCounter + 100 < GetTime() then
			GetClaw().SetAnimation(GetClaw(), "CLAW_STAND", 100)
			
			self.stage = 49
		end
	end
	if self.stage == 49 then 
		local dir = 1
		if self.RedTail2.DrawFlags.Mirror then
				dir = 1 -- prawo
			else
				dir = -1
			end
		--if self.TacticalMagicClaw.X + 40 * dir <= self.RedTail2.X then
		if math.abs(self.TacticalMagicClaw.X - self.RedTail2.X) <= 40 then
			--self.TacticalMagicClaw:Destroy()
			self.TacticalMagicClaw.Y = 9000
			--self.TacticalMagicClaw = nil
			self.RedTail2:SetAnimation("LEVEL_REDTAIL_HITHIGH")
			self.hehechyba = CreateObject {x=self.RedTail2.X, y=self.RedTail2.Y-20, z=4100, logic="Bullet", image="CUSTOM_HEHECHYBA", SpeedX = 600*dir, SpeedY = 25}
			PlaySound("LEVEL_REDTAIL_01040006")
			self.TimeCounter = GetTime()
			self.stage = 50
		end 
	end 
	if self.stage == 50 then 
		if self.TimeCounter + 100 < GetTime() then
			self.RedTail2:SetAnimation("LEVEL_REDTAIL_IDLE")
			self.TimeCounter = GetTime()
			self.stage = 51
		end
	end 
	if self.stage == 51 then 
		if self.TimeCounter + 1000 < GetTime() then
			self.objExc2.X = self.RedTail2.X
			self.objExc2.Y = self.RedTail2.Y-80
			self.objExc2.DrawFlags.NoDraw = false
			PlaySound("LEVEL_REDTAIL_01040021")
			self.stage = 52
		end
	end 
	if self.stage == 52 then 
		if self.TimeCounter + 2360 < GetTime() then
			self.RedTail2:SetAnimation("LEVEL_REDTAIL_JUMP")
			PlaySound("LEVEL_REDTAIL_RTJUMP")
			self.RedTail2.SpeedY = -10
			self.stage = 53
		end
	end 
	if self.stage == 53 then 
		self.RTWind.Speed = 0
		GetClaw().State = 24
		CameraToClaw()
		CreateObject {x=83632, y=5170, z=4000, logic="EndOfLevelPowerup", image="GAME_MAPPIECE"}
		CreateObject {x=83532, y=5170, z=4000, logic="DoNothing", image="CUSTOM_ACHIEVEMENTSWARP"}
		if self.achievementRedTail == 1 then
			self.Achievements.achievements_input[3] = 1
		end
		self.Achievements.achievements_input[1] = 1
		self.hiddenwarp = CreateObject {x=83532, y=5170, z=4000, logic="SpecialPowerup", image="GAME_VERTWARP", SpeedX = 110813, SpeedY = 5109}
		self.hiddenwarp.DrawFlags.NoDraw = true
		self.BossHealth = nil
		self.stage = 54
	end 
	if self.stage == 53 or self.stage == 54 then
		if self.objExc2 ~= nil then
			self.objExc2.X = self.RedTail2.X
			self.objExc2.Y = self.RedTail2.Y-80
		end
		if self.RedTail2 ~= nil then
			if self.RedTail2.Y <= 83380 then
				self.RedTail2.X = self.RedTail2.X - 3
				self.RedTail2.Y = self.RedTail2.Y + self.RedTail2.SpeedY
				if self.RedTail2.SpeedY < 10 then
					self.RedTail2.SpeedY = self.RedTail2.SpeedY + 1
				end
			else
				self.RedTail2:Destroy()
				self.RedTail2 = nil
			end
		end
	end--]]
	
	--if self.vadmrl ~= nil then
	--	TextOut(self.vadmrl.State)
	--end
	
	if self.bossbar ~= nil then
		UpdateBossBar(self)
	end
		
	if self.BossActive ~= nil then
		if self.BossActive == 1 then
			self.BossHealth = self.Areti.Health
			if self.Achievements.extra == true then
				self.BossHealth = self.Areti.Health/2
			end
		end
	end
	 	
end
end

function attack(self)
	local claw = GetClaw()
	--local attempt = Attempt()
	local state = claw.State
	
	if self.StartCondition == nil then
		self.stage = 0
		self.StartCondition = 1
	end
	--elseif attempt > self.lastattempt then
	--	self.lastattempt = attempt
	--	self.stage = 12
	--end
	
end